/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.List;

public class OutboundConfigData
implements Persistable {
    private static final String TRACE_MASKT = "XRCSOCDT";
    private static final String TRACE_MASKF = "XRCSOCDF";
    private static final String TRACE_MASKD = "XRCSOCDD";
    private boolean callHomeServer = false;
    private boolean allowDial = false;
    private List phoneInfo = new ArrayList();
    private boolean allowInternet = false;
    private boolean allowPassthru = false;
    private List passthruInfo = new ArrayList();
    private boolean allowEtsDial = false;
    private int etsProtocol = 0;
    private List etsPhoneInfo = new ArrayList();
    public static final int ETS_PROTOCOL_ACTS = 0;
    public static final int ETS_PROTOCOL_CTD = 1;
    public static final int ETS_PROTOCOL_CTS = 2;

    public OutboundConfigData() {
        Trace.trace(TRACE_MASKT, "<> OutboundConfigData()");
    }

    protected OutboundConfigData(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        this.callHomeServer = persistent.callHomeServer;
        this.allowDial = persistent.allowDial;
        this.phoneInfo = persistent.phoneInfo;
        this.allowInternet = persistent.allowInternet;
        this.allowPassthru = persistent.allowPassthru;
        this.passthruInfo = persistent.passthruInfo;
        if (persistent.version < 2) {
            this.allowEtsDial = false;
            this.etsProtocol = 0;
            this.etsPhoneInfo = new ArrayList();
        } else {
            this.allowEtsDial = persistent.allowEtsDial;
            this.etsProtocol = persistent.etsProtocol;
            this.etsPhoneInfo = persistent.etsPhoneInfo;
        }
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        persistent.version = 2;
        persistent.callHomeServer = this.callHomeServer;
        persistent.allowDial = this.allowDial;
        persistent.phoneInfo = this.phoneInfo;
        persistent.allowInternet = this.allowInternet;
        persistent.allowPassthru = this.allowPassthru;
        persistent.passthruInfo = this.passthruInfo;
        persistent.allowEtsDial = this.allowEtsDial;
        persistent.etsProtocol = this.etsProtocol;
        persistent.etsPhoneInfo = this.etsPhoneInfo;
        return persistent;
    }

    public boolean isUpgradeData() {
        return true;
    }

    public boolean isCallHomeServer() {
        return this.callHomeServer;
    }

    public void setCallHomeServer(boolean value) {
        this.callHomeServer = value;
    }

    public boolean isAllowDial() {
        return this.allowDial;
    }

    public void setAllowDial(boolean value) {
        this.allowDial = value;
    }

    public List getPhoneInfo() {
        return this.phoneInfo;
    }

    public void setPhoneInfo(List info) {
        this.phoneInfo = info;
    }

    public boolean isAllowInternet() {
        return this.allowInternet;
    }

    public void setAllowInternet(boolean value) {
        this.allowInternet = value;
    }

    public boolean isAllowPassthru() {
        return this.allowPassthru;
    }

    public void setAllowPassthru(boolean value) {
        this.allowPassthru = value;
    }

    public List getPassthruInfo() {
        return this.passthruInfo;
    }

    public void setPassthruInfo(List info) {
        this.passthruInfo = info;
    }

    public boolean isAllowEtsDial() {
        return this.allowEtsDial;
    }

    public void setAllowEtsDial(boolean value) {
        this.allowEtsDial = value;
    }

    public int getEtsProtocol() {
        return this.etsProtocol;
    }

    public void setEtsProtocol(int protocol) {
        if (!this.isValidEtsProtocol(protocol)) {
            throw new IllegalArgumentException("Invalid external time source protocol");
        }
        this.etsProtocol = protocol;
    }

    private boolean isValidEtsProtocol(int protocol) {
        switch (protocol) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public List getEtsPhoneInfo() {
        return this.etsPhoneInfo;
    }

    public void setEtsPhoneInfo(List info) {
        this.etsPhoneInfo = info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[OutboundConfigData: ");
        sb.append("callHomeServer=" + this.callHomeServer + ", ");
        sb.append("allowDial=" + this.allowDial + ", ");
        sb.append("phoneInfo=" + this.phoneInfo.size() + ", ");
        sb.append("allowInternet=" + this.allowInternet + ", ");
        sb.append("allowPassthru=" + this.allowPassthru + ", ");
        sb.append("passthruInfo=" + this.passthruInfo.size() + ", ");
        sb.append("allowEtsDial=" + this.allowEtsDial + ", ");
        sb.append("etsProtocol=" + this.etsProtocol + ", ");
        sb.append("etsPhoneInfo=" + this.etsPhoneInfo.size());
        sb.append("]");
        return sb.toString();
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -8418437109512450611L;
        int version;
        boolean callHomeServer;
        boolean allowDial;
        List phoneInfo;
        boolean allowInternet;
        boolean allowPassthru;
        List passthruInfo;
        boolean allowEtsDial;
        int etsProtocol;
        List etsPhoneInfo;

        private Persistent() {
        }
    }
}

